#!/usr/bin/perl -w

# G-CODE converter from Eagle 4.0 CNC -> EMC converter
# Released under GPL
# Henry Palonen, h@yty.net, 6.3.2001

# parameters

my $Zup = "0.1"; 			# Z axis up position
my $Zdn = "0.0";			# Z axis down position
my $gcodestart = "G0\nG20\n";		# G-code inserted to start of output (G20 = millimeters)
my @erasethese = ("G01", "D10");	# We don't want to output these codes.

#### NO PARAMS BELOW THIS LINE ####

my $infile = $ARGV[0];
my $line = "";
my $oldline = "";
my $pos = "";

die "Usage: ./eagle2cnc.pl infile.cnc > outfile.cnc\n" unless $infile;

open (A, $infile) || die "Cannot open $infile: $!";

# Start to output G-code.
print "$gcodestart";

while (<A>) {
	$line = $_;
	chomp ($line);
	$line =~ s/\*$//;
	$line =~ s/(X..)/$1./;
	$line =~ s/(Y..)/ $1./;
	foreach (@erasethese) {$line =~ s/$_//g;}
	# if there is D02 in line, put previous coordinates
	# and Z axis to UP position. Only after that print
	# the move got from current line.
	if ($line =~ s/D02/ Z$Zup/) {
		$pos = "up";
		if ($oldline =~ s/Z$Zdn/Z$Zup/) {
			print "$oldline\n";
		}
	}

	# if there is D01 in line and we are in UP position,
	# put Z axis to down position. After that print the 
	# move command got from current line.
	if (($line =~ s/D01/ Z$Zdn/) and ($pos="up")) {
		if ($oldline =~ s/Z$Zup/Z$Zdn/) {
			print "$oldline\n";
		}
		$pos = "dn";
	}
	print "$line\n";
	$oldline = $line;
}

# End of G-code output
close A;
